package ru.yandex.direct.chassis.util.calendar

import com.fasterxml.jackson.annotation.JsonProperty
import java.time.LocalDate

data class HolidaysResponse(
    val holidays: List<HolidayItem>,
)

data class HolidayItem(
    val date: LocalDate,
    val type: HolidayType,
    val name: String?,
    val isTransfer: Boolean,
)

enum class HolidayType {
    @JsonProperty("holiday")
    HOLIDAY,

    @JsonProperty("weekend")
    WEEKEND,

    @JsonProperty("weekday")
    WEEKDAY,
}
