package ru.yandex.direct.chassis.util.calendar

import com.google.common.cache.CacheBuilder
import com.google.common.cache.CacheLoader
import com.google.common.cache.LoadingCache
import org.springframework.stereotype.Component
import java.time.LocalDate

@Component
class HolidayService(private val calendarClient: CalendarClient) {
    private val holidayCache: LoadingCache<LocalDate, HolidayItem> = CacheBuilder
        .newBuilder()
        .build(object : CacheLoader<LocalDate, HolidayItem>() {
            override fun load(date: LocalDate): HolidayItem =
                calendarClient.getHolidays(date, date).first()
        })

    fun getHoliday(date: LocalDate): HolidayItem =
        holidayCache[date]
}
