package ru.yandex.direct.chassis.util.staff

import org.springframework.scheduling.TaskScheduler
import ru.yandex.direct.staff.client.StaffClient
import java.time.Duration
import java.time.Instant
import java.util.concurrent.atomic.AtomicReference

class StaffTelegramAccountsProvider(
    private val staffClient: StaffClient,
    private val taskScheduler: TaskScheduler,
) {
    private val refreshDuration = Duration.ofMinutes(30)

    private val logins: AtomicReference<Set<String>> = AtomicReference(setOf())

    fun start() {
        update()
        taskScheduler.scheduleAtFixedRate(
            this::update,
            Instant.now() + refreshDuration,
            refreshDuration,
        )
    }

    fun update() {
        val accounts = staffClient
            .getStaffUsers(
                """(groups.group.ancestors.url=="yandex_monetize_search_direct_interface_dep16266""""
                    + """ or groups.group.ancestors.url=="yandex_monetize_search_direct_interface")"""
                    + """ and accounts.type=="telegram"""",
                "accounts"
            )

        val loginSet = accounts
            .flatMap { it.accounts }
            .filter { it.type == "telegram" }
            .filter { !it.private }
            .map { it.value }
            .toSet()

        logins.set(loginSet)
    }

    fun getLogins(): Set<String> = logins.get()
}
