package ru.yandex.direct.chassis.util.startrek

import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
class ChecklistItemUpdate(
    val text: String? = null,
    val checked: Boolean? = null,
) {
    companion object {
        fun check(checked: Boolean = true) = ChecklistItemUpdate(checked = checked)
        fun uncheck() = ChecklistItemUpdate(checked = false)
    }
}
