package ru.yandex.direct.chassis.util.startrek

object StartrekQueue {
    const val DIRECT = "DIRECT"
    const val DIRECTMIGR = "DIRECTMIGR"
    const val TESTIRT = "TESTIRT"
    const val DIRECTINCIDENTS = "DIRECTINCIDENTS"
    const val SPI = "SPI"
    const val TESTSPI = "TESTSPI"
    const val TEST = "TEST"
    const val SPPROBLEM = "SPPROBLEM"
}

object StartrekStatusKey {
    const val OPEN = "open"
    const val NEED_INFO = "needInfo"
    const val IN_PROGRESS = "inProgress"
    const val BETA_TESTED = "betaTested"
    const val AWAITING_RELEASE = "awaitingRelease"
    const val READY_FOR_TEST = "readyForTest"
    const val TESTING = "testing"
    const val RM_ACCEPTANCE = "rmAcceptance"
    const val READY_TO_DEPLOY = "readyToDeploy"
    const val CLOSED = "closed"
}

object StartrekDisplayStatus {
    const val BETA_TESTED = "Beta-tested"
    const val AWAITING_RELEASE = "Awaiting Release"
    const val CLOSED = "Closed"
}

object StartrekResolution {
    const val FIXED = "fixed"
}

object StartrekTransition {
    const val START_PROGRESS = "start_progress"
}

object StartrekComponent {
    const val SPI_DIRECT = 84635L
    const val SPI_BANNER = 48411L
    const val SPI_METRIKA = 85116L
    const val SPI_PCODE = 85120L
    const val SPI_MODADVERT = 85118L
    const val INCIDENTS_NONE = 30587L
    const val JAVA_JOBS = 31819L
    const val RELEASES_JAVA_DIRECT = 33409L
    const val ESS_ROUTER = 53425L
    const val BINLOGBROKER = 49723L

    const val RELEASE_DEPENDENCY = "Зависимости между релизами"
    const val LIMTEST = "Limtest"
    const val POSTPONED_ACTION = "app-duty-postponed-action"
}

object StartrekTag {
    const val CHECK_JOBS_REGRESSION = "check_jobs_regression"
    const val FOUND_IN_JOBS_REGRESSION = "found_in_jobs_regression"

    const val CREATED_BY_CHECKER = "created_from_checker"
    const val AUTO_PROCESSED_WORKING_HOURS = "auto_processed_working_hours"
    const val SPI_ACTION_ITEM = "spi:actionitem"
    const val SPI_VICTIM = "spi:victim"
    const val SPI_PROBLEM = "spi:problem"
    const val SPI_PREFIX = "direct:"
    const val DIRECT_INCIDENT_RESPONSE = "direct_incident_response"
    const val DONT_REMIND = "dont_remind"

    const val RELEASE_TESTING = "release_testing"
    fun releaseTesting(app: String) = "release_testing_$app"

    const val NOTIFICATION_DONE = "notification_done"
    fun notificationDone(app: String) = "notification_done_$app"

    // Теги для отдельных тикетов в релизах perl
    const val REGRESSION_PERL_API_TAG = "direct_release_api"
    const val REGRESSION_PERL_INTAPI_TAG = "direct_release_intapi"
    const val REGRESSION_PERL_CMD_TAG = "direct_release_cmd"
    const val ESS_ROUTER_HEATH_CHECK = "ess_router_health_check"
    const val BINLOGBROKER_HEATH_CHECK = "binlogbroker_health_check"
}

object StartrekField {
    const val NUMBER_OF_CRM_TICKETS = "crmNums"
    const val NUMBER_OF_USERS = "numberOfUsers"
    const val NUMBER_OF_COMPLAINTS = "numberOfComplaints"

    const val AFFECTED_APPS = "affectedApps"
    const val TESTED_APPS = "testedApps"

    const val HOW_TO_TEST = "howToTest"

    const val QA_ENGINEER = "qaEngineer"

    const val SANDBOX_BUILD_TASK = "6061b65f6669ed0a30e9e041--sandboxBuildTask"
}

object StartrekIssueTypeKey {
    const val RELEASE = "release"
}

const val NONE_AFFECTED_APP = "none"
