package ru.yandex.direct.chassis.util.svn

import org.tmatesoft.svn.core.SVNErrorMessage
import org.tmatesoft.svn.core.SVNURL
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider
import org.tmatesoft.svn.core.auth.SVNAuthentication
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHPrivateKeyUtil

class SshAgentAuthenticationProvider(
    private val user: String
) : ISVNAuthenticationProvider {

    override fun requestClientAuthentication(
        kind: String?,
        url: SVNURL,
        realm: String?,
        errorMessage: SVNErrorMessage?,
        previousAuth: SVNAuthentication?,
        authMayBeStored: Boolean
    ): SVNAuthentication? {
        val agentProxy = SVNSSHPrivateKeyUtil.createOptionalSSHAgentProxy()
        return SVNSSHAuthentication.newInstance(
            user,
            agentProxy,
            url.port,
            url,
            false
        )
    }

    override fun acceptServerAuthentication(
        url: SVNURL?, realm: String?, certificate: Any?,
        resultMayBeStored: Boolean
    ) = ISVNAuthenticationProvider.ACCEPTED
}
