package ru.yandex.direct.chassis.util.svn

import org.slf4j.LoggerFactory
import org.tmatesoft.svn.util.SVNDebugLog
import org.tmatesoft.svn.util.SVNDebugLogAdapter
import org.tmatesoft.svn.util.SVNLogType
import java.util.logging.Level

class SvnLogSlf4jAdapter : SVNDebugLogAdapter() {
    private val logger = LoggerFactory.getLogger(SVNDebugLog::class.java)

    override fun log(
        logType: SVNLogType,
        th: Throwable,
        logLevel: Level
    ) {
        logger.debug("$logType: $logLevel", th)
    }

    override fun log(
        logType: SVNLogType,
        message: String,
        logLevel: Level
    ) {
        logger.debug("$logType: $logLevel, $message")
    }

    override fun log(
        logType: SVNLogType,
        message: String,
        data: ByteArray
    ) {
        logger.trace(logType.toString() + ": " + message + ":" + String(data))
    }
}
