package ru.yandex.direct.chassis.util.versionica

import org.asynchttpclient.AsyncHttpClient
import org.springframework.stereotype.Component
import ru.yandex.direct.asynchttp.FetcherSettings
import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.http.smart.annotations.Json
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors
import ru.yandex.direct.http.smart.http.GET
import ru.yandex.direct.http.smart.http.Headers
import ru.yandex.direct.http.smart.http.Query

@Component
class VersionicaClient(
    asyncHttpClient: AsyncHttpClient,
) {
    private val baseUrl = "http://direct-dev.yandex-team.ru/versionica"

    private val api: VersionicaApi = Smart.builder()
        .withParallelFetcherFactory(ParallelFetcherFactory(asyncHttpClient, FetcherSettings()))
        .withProfileName("versionica_client")
        .withBaseUrl(baseUrl)
        .build()
        .create(VersionicaApi::class.java)

    fun getPropertyLogs(
        property: String,
        hostGroup: List<String>,
        reqId: String = "",
        host: String = "",
        group: String = "",
        responseType: String = "json",
    ): List<PropertyLogEntry> =
        api.getPropertyLogs(property, hostGroup.joinToString(";"), reqId, host, group, responseType)
            .executeCall()

    private fun <T> Call<T>.executeCall(): T {
        val result = execute()
        checkResultForErrors(result, { RuntimeException(it) })
        return result.success
    }
}

interface VersionicaApi {
    @GET("/propertylog")
    @Json
    @Headers("Content-Type: application/json")
    fun getPropertyLogs(
        @Query("property") property: String,
        @Query("host_group") hostGroup: String,
        @Query("reqid") reqId: String,
        @Query("host") host: String,
        @Query("group") group: String,
        @Query("as") responseType: String,
    ): Call<List<PropertyLogEntry>>
}
