package ru.yandex.direct.chassis.util.ydb

import org.slf4j.LoggerFactory
import ru.yandex.direct.chassis.entity.reports.incident.ActionItemsReporter
import ru.yandex.direct.chassis.entity.reports.incident.IncidentsReporter
import ru.yandex.direct.chassis.entity.reports.incident.IncidentsScoring
import ru.yandex.direct.chassis.properties.YdbSettings
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.support.DirectJob

/**
 * Костылик, чтобы разово выполнять пересоздание табличек из кода.
 * Оформлен таской без расписания, которой после старта приложения ставится "запусти меня сейчас"
 */
@Hourglass
class CreateYdbTablesJob(
    private val ydbSettings: YdbSettings,
    private val incidentsScoring: IncidentsScoring,
    private val incidentsReporter: IncidentsReporter,
    private val actionItemsReporter: ActionItemsReporter,
) : DirectJob() {
    private val logger = LoggerFactory.getLogger(CreateYdbTablesJob::class.java)
    override fun execute() {
        logger.info("let's create necessary tables in YDB")

        ydbSettings.createTables()
        logger.info("settings table created")

        incidentsScoring.createTables()
        logger.info("incidents statistics tables created")

        incidentsReporter.createTables()
        logger.info("incidents tables created")

        actionItemsReporter.createTables()
        logger.info("action items tables created")
    }
}
