package ru.yandex.direct.currencyimporter;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.jcommander.ParserWithHelp;

public class CurrencyImportTool {
    private static final String CURRENCY_CLASS_NAME = "Currency";
    private static final String INTERFACE_PACKAGE = CurrencyCode.class.getPackage().getName();
    private static final String CURRENCIES_PACKAGE = INTERFACE_PACKAGE + ".currencies";

    private CurrencyImportTool() {
    }

    public static void main(String[] args) throws IOException {
        CurrencyImportToolParams params = new CurrencyImportToolParams();
        ParserWithHelp.parse(CurrencyImportTool.class.getCanonicalName(), args, params);
        importCurrency(params);
    }

    private static void importCurrency(CurrencyImportToolParams params) {
        try {
            //JCommander arity = 1 не сработало на main-параметр
            if (params.getRemoteJson().size() != 2) {
                throw new CurrencyImportException("Two remote JSONs are mandatory parameters");
            }
            URL currenciesRemoteJson = params.getRemoteJson().get(0);
            URL ratesRemoteJson = params.getRemoteJson().get(1);
            System.err.println(String.format("remote json locations: '%s', '%s' write generated sources to '%s'",
                    currenciesRemoteJson, ratesRemoteJson, params.getJavaSourcesDestRoot()));

            File destRoot = new File(params.getJavaSourcesDestRoot());
            if (!destRoot.exists() || !destRoot.isDirectory()) {
                throw new CurrencyImportException("invalid root folder for generated sources");
            }

            CurrencyImporter importer =
                    new CurrencyImporter(currenciesRemoteJson, ratesRemoteJson, destRoot,
                            CURRENCIES_PACKAGE, INTERFACE_PACKAGE, CURRENCY_CLASS_NAME
                    );
            importer.doImport();
        } catch (CurrencyImportException | CurrencyImporterConfigException ex) {
            System.err.println(String.format("can't import currency JSON: %s", ex.getMessage()));
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }
}
