package ru.yandex.direct.currencyimporter;

import java.net.URL;
import java.util.List;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.URLConverter;

public class CurrencyImportToolParams {
    private List<URL> remoteJson;

    private String javaSourcesDestRoot;

    @Parameter(
            names = {"-j", "--java-sources-dest-root"},
            description = "place generated sources within directory", required = true
    )
    public void setJavaSourcesDestRoot(String javaSourcesDestRoot) {
        this.javaSourcesDestRoot = javaSourcesDestRoot;
    }

    public String getJavaSourcesDestRoot() {
        return javaSourcesDestRoot;
    }

    @Parameter(description = "remote JSON url", required = true, converter = URLConverter.class)
    public void setRemoteJson(List<URL> remoteJson) {
        this.remoteJson = remoteJson;
    }

    // Как это ни странно, но JCommander требует как getter, так и setter (оба - для List).
    // Поэтому притвориться, что у нас всего 1 параметр, и возвращать URL - не получиться
    // Что еще более странно - JCommander ставит ссылку на List, после чего модифицирует
    // исходный List (не вызывая setter).
    // Т.о, если делать defense copy(в setter) с пом ImmutableList.copyOf - аргументы командной строки будут утеряны
    public List<URL> getRemoteJson() {
        return remoteJson;
    }

    @Override
    public String toString() {
        return CurrencyImportToolParams.class.getSimpleName() + "[" + javaSourcesDestRoot + ";" + remoteJson + "]";
    }
}
