package ru.yandex.direct.dbschemagen;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * Реализация {@link GenericSourceInfo} для случая генерации БД не из VCS
 */
public class AbsentSourceInfo implements GenericSourceInfo {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void save(Path path) throws IOException {
        MAPPER.writerWithDefaultPrettyPrinter().writeValue(path.toFile(),
                Map.of("source_type", "generated without VCS"));
    }

    @Override
    public boolean isReproducible() {
        return false;
    }

    @Override
    public String getTagString() {
        return "local";
    }

    @Override
    public boolean sameAs(GenericSourceInfo other) {
        return false;
    }

    @Override
    public boolean mysqlServerDiffers(GenericSourceInfo other) {
        return false;
    }
}
