package ru.yandex.direct.dbschemagen;

import java.nio.file.Path;
import java.nio.file.Paths;

import static ru.yandex.direct.dbschemagen.SvnWorker.SVN_ROOT;
import static ru.yandex.direct.process.Processes.checkOutput;

public class ArcWorker implements VcsWorker {
    @Override
    public VcsReference createVcsReference(Path sourceCodePath, DbSchemaUpdateVcsParams params) throws Exception {
        if (!params.isForceGenerate()) {
            throw new UnsupportedOperationException("Currently only --force-generate supported for arc");
        }
        long rev = 0L;
        boolean hasChanges = false;
        return new VcsReference(SVN_ROOT, rev, hasChanges, false);
    }

    @Override
    public Path getWorkingCopyRoot() throws Exception {
        return Paths.get(checkOutput("arc", "root").replace("\n", ""));
    }

    @Override
    public void registerChanges(Path dbSchemaLibPath) throws Exception {
        String vcsRoot = checkOutput("arc", "root").trim();
        checkOutput("arc", "add", vcsRoot);
    }
}
