package ru.yandex.direct.dbschemagen;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

@SuppressWarnings("checkstyle:visibilitymodifier")
public class DbSchemaGenParams {
    @Parameter(
            names = {"-g", "--generated-code-path"},
            description = "Where to place generated code"
    )
    public String generatedCodePath = ".";

    @Parameter(
            names = {"-p", "--package-namespace"},
            required = true,
            description = "Prefix for package names containing generated schema classes"
    )
    public String packageNamespace;

    @Parameter(
            names = {"-G", "--guess-artificial-bigint-columns"},
            description = "This is suitable for bootstrapping and updating variable"
                    + " DbSchemaUpdateSvn.ARTIFICIAL_BIGINT_COLUMNS"
    )
    public boolean guessArtificialBigintColumns = false;

    @Parameter(
            required = true,
            description = "<schema-sql-dir> ..."
    )
    public List<String> schemaSqlDirs = new ArrayList<>();
}
