package ru.yandex.direct.dbschemagen;

import com.beust.jcommander.Parameter;

class DbSchemaUpdateSvnParams implements DbSchemaUpdateVcsParams {
    @Parameter(
            names = {"-r", "--revision"},
            description = "SVN revision of direct db_schema"
    )
    String revision = "HEAD";

    @Parameter(
            names = {"-u", "--url"},
            description = "SVN URL or local path of direct db_schema directory"
    )
    String url = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/perl/db_schema";

    @Parameter(
            names = {"--force-upload"},
            description = "Update sandbox resources and docker image despite dirty working copy"
    )
    boolean forceUpload = false;

    @Parameter(
            names = {"--force-mysql-server-upload"},
            description = "Update mysql server sandbox resource even if source docker image is not changed"
    )
    boolean forceMysqlServerUpload = false;

    @Parameter(
            names = {"-f", "--force-generate"},
            description = "Ignore checks for revisions and branch. Useful when generating for branches"
    )
    boolean forceGenerate = false;

    @Override
    public boolean isForceGenerate() {
        return forceGenerate;
    }

}
