package ru.yandex.direct.dbschemagen;

import java.util.regex.Pattern;

import org.jooq.codegen.DefaultGeneratorStrategy;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;

/**
 * Стратегия генерации имён. Умолчательное превращение statusShow -> STATUS_SHOW - не устраивает.
 */
public class DirectGeneratorStrategy extends DefaultGeneratorStrategy {
    private static final Pattern CASE_CHANGE_PATTERN = Pattern.compile("([a-z])([A-Z])");
    private static final String CASE_CHANGE_REPLACEMENT = "$1_$2";

    @Override
    public String getJavaIdentifier(Definition definition) {
        if (definition instanceof ColumnDefinition) {
            return makeUnderscoreName(definition.getInputName());
        } else {
            return super.getJavaIdentifier(definition);
        }
    }

    static String makeUnderscoreName(String name) {
        return CASE_CHANGE_PATTERN.matcher(name)
                .replaceAll(CASE_CHANGE_REPLACEMENT)
                .toUpperCase();
    }
}
