package ru.yandex.direct.dbschemagen;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;

import static ru.yandex.direct.dbschemagen.SvnWorker.SVN_ROOT;
import static ru.yandex.direct.process.Processes.checkOutput;

public class HgWorker implements VcsWorker {
    private static final String ARCADIA_REV = "arcadia@";
    private final Pattern revPattern = Pattern.compile(ARCADIA_REV + "\\d+");

    @Override
    public VcsReference createVcsReference(Path sourceCodePath, DbSchemaUpdateVcsParams params) throws Exception {
        String branch = checkOutput("hg", "branch").replace("\n", "");
        if (!StringUtils.equals(branch, "default") && !params.isForceGenerate()) {
            throw new RuntimeException("Please switch to default first");
        }

        boolean hasChanges = Stream.of(checkOutput("hg", "st", "-mard")
                .split("\n"))
                .anyMatch(StringUtils::isNotEmpty);

        String revStr = checkOutput("hg", "log", "-T", "'{extras}\\n'", "-l", "1", "-r", "default");
        Matcher revMatcher = revPattern.matcher(revStr);
        long rev;
        if (revMatcher.find()) {
            rev = Long.valueOf(revMatcher.group().replace(ARCADIA_REV, ""));
        } else if (params.isForceGenerate()) {
            rev = 0L;
        } else {
            throw new RuntimeException(
                    "Cannot get svn revision for default branch. " +
                            "Please check output of 'hg log -T \"{extras}\\n\" -l 1 -r default' under arcadia.hg root");
        }
        if (params.isForceGenerate()) {
            hasChanges = false;
        }

        return new VcsReference(SVN_ROOT, rev, hasChanges, false);
    }

    @Override
    public Path getWorkingCopyRoot() throws Exception {
        return Paths.get(checkOutput("hg", "root").replace("\n", ""));
    }

    @Override
    public void registerChanges(Path dbSchemaLibPath) throws Exception {
        checkOutput("hg", "addremove");
        checkOutput("hg", "add", ".");
    }
}
