package ru.yandex.direct.dbschemagen;

import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.mysql.MySQLDatabase;

import ru.yandex.direct.mysql.MySQLDockerContainer;

public class JooqDbInfo {
    private MySQLDockerContainer mysql;

    public JooqDbInfo(MySQLDockerContainer mysql) {
        this.mysql = mysql;
    }

    public Jdbc jooqJdbc() {
        return new Jdbc()
                .withDriver("com.mysql.jdbc.Driver")
                .withUser("root")
                .withPassword("")
                .withUrl("jdbc:mysql://" + mysql.getHostPort() + "/");
    }

    public Database jooqDatabase() {
        return new Database().withName(MySQLDatabase.class.getCanonicalName());
    }
}
