package ru.yandex.direct.dbschemagen;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class VcsReference {
    private String url;
    private long revision;
    private boolean hasLocalModifications;
    private boolean mixedRevision;

    @JsonCreator
    public VcsReference(
            @JsonProperty("url") String url,
            @JsonProperty("revision") long revision,
            @JsonProperty("hasLocalModifications") boolean hasLocalModifications,
            @JsonProperty("mixedRevision") boolean mixedRevision
    ) {
        this.url = url;
        this.revision = revision;
        this.hasLocalModifications = hasLocalModifications;
        this.mixedRevision = mixedRevision;
    }

    @JsonValue
    public JsonNode toJson() {
        return new ObjectMapper().createObjectNode()
                .put("url", url)
                .put("revision", revision)
                .put("hasLocalModifications", hasLocalModifications)
                .put("mixedRevision", mixedRevision);
    }

    public String getUrl() {
        return url;
    }

    public long getRevision() {
        return revision;
    }

    public boolean hasLocalModifications() {
        return hasLocalModifications;
    }

    public boolean isMixedRevision() {
        return mixedRevision;
    }

    public boolean isReproducible() {
        return !hasLocalModifications && !mixedRevision;
    }

    /**
     * @return true, если ссылки точно одинаковые, false - если разные или потенциально разные,
     * например и там и там есть локальные изменения, но неизвестно какие они.
     */
    public boolean sameAs(VcsReference other) {
        return (other != null)
                && url.equals(other.url)
                && (revision == other.revision)
                && !hasLocalModifications
                && !other.hasLocalModifications
                && !mixedRevision
                && !other.mixedRevision;
    }
}
