package ru.yandex.direct.dbschemagen;

import static ru.yandex.direct.process.Processes.communicateUnsafe;

public class VcsWorkerFactory {
    private static final SvnWorker SVN_WORKER = new SvnWorker();
    private static final HgWorker HG_WORKER = new HgWorker();
    private static final ArcWorker ARC_WORKER = new ArcWorker();

    private VcsWorkerFactory() {
    }

    public static VcsWorker getWorker() throws InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("svn", "info");
        pb.environment().put("LC_ALL", "C");
        pb.environment().put("LANGUAGE", "C");
        boolean isSvn =
                !communicateUnsafe(pb).getStderr().contains("is not a working copy");
        boolean isHg;
        try {
            pb = new ProcessBuilder("hg", "root");
            pb.environment().put("LC_ALL", "C");
            pb.environment().put("LANGUAGE", "C");
            isHg = !communicateUnsafe(pb).getStderr().contains("no repository found");
        } catch (Exception e) {
            isHg = false;
        }
        boolean isArc;
        try {
            pb = new ProcessBuilder("arc", "root");
            pb.environment().put("LC_ALL", "C");
            pb.environment().put("LANGUAGE", "C");
            isArc = !communicateUnsafe(pb).getStderr().contains("Not an arc repository");
        } catch (Exception e) {
            isArc = false;
        }

        if (isHg) {
            return getHgWorker();
        } else if (isArc) {
            return getArcWorker();
        } else if (isSvn) {
            return getSvnWorker();
        } else {
            throw new RuntimeException(
                    "Current directory is invalid. Please run in from direct/apps/dbschemagen under svn or hg");
        }
    }

    public static SvnWorker getSvnWorker() {
        return SVN_WORKER;
    }

    public static HgWorker getHgWorker() {
        return HG_WORKER;
    }

    public static ArcWorker getArcWorker() {
        return ARC_WORKER;
    }
}
