package ru.yandex.direct.apps.tanker.tool;

import java.io.IOException;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.i18n.tanker.cli.CommonParams;
import ru.yandex.direct.i18n.tanker.cli.DownloadCommand;
import ru.yandex.direct.i18n.tanker.cli.TankerTool;

public class DirectTankerTool {
    private DirectTankerTool() {
    }

    public static void main(String[] args) throws IOException {
        DirectConfig config = DirectConfigFactory.getConfig(EnvironmentType.PRODUCTION).getBranch("tanker");
        new TankerTool(
                new CommonParams()
                        .withProject(config.getString("project"))
                        .withTokenFile(config.getString("token_file")),
                new DownloadCommand()
        ).run(args);
    }
}
