# event-sourcing-system

Страница в [документации](https://docs.yandex-team.ru/direct-dev/ess/concept)

event-sourcing-system состоит из двух приложений:
1. Router - самостоятельное приложение, читающее бинлоги из LogBroker-топика, применяющее пользовательские правила фильтрации и записывающее результат в следующие топики.
    Пользовательское правило - наследник класса AbstractRule, производящее отбор нужных для задачи бинлогов.
2. Logic processor - работает на инфраструктуре jobs. Читает отфильтрованные router'ом данные из Logbroker'а, выполняет с ними полезную работу.
    Каждый logicProcessor - наследник класса BaseLogicProcessor, представляет собой шардированный Job. Все события шарда будут попадать в logic-processor с таким же шардом

### Начало работы
Перед написанием своих правил фильтрации и бизнес-логики нужно:
1. Придумать промежуточной топик между, в который router будет писать данные, а бизнес-логика - читать. Для создания топика можно использовать [скрипт](../../../bin/create_ess_topic.sh) (но для его выполнения нужно запросить права)
Все топики в логброкере находятся в direct/<env>/ess/. При выполнении скрипта нужно указать среду (devtest, testing, prod) и относительное название топика(без direct/<env>/ess)

2. Придумать объект, который будет передаваться от router'а к бизнес-логике, объект является наследником класса BaseLogicObject.
Так как роутер записывает в топик события в формате json, объект должен быть сериализуемым в json и десериализуемым из json.

3. Создать класс конфиг для всех цепочки - наследник класса BaseEssConfig. Он содержит методы:
- getTopic название промежуточного топика
- getLogicObject класс промежуточного объекта из п.2
- getRowsThreshold - максимальное количество пользовательских объектов, которое будет читаться из logbroker'а для одной итерации бизнес-логики.
- getTimeToReadThreshold - максимальное количество времени для чтения событий из logbroker'а для одной итерации бизнес-логики. По достижении либо TimeToReadThreshold, либо RowsThreshold, чтение из логброкера прекращается и данные передаются для обработки бизнес-логикой.
- getCriticalEssProcessTime - критическое время отставания выполнения всей цепочки ess от создания binlog'a. При его превышении в juggler проставится статус CRIT.
- getLogicProcessName - название, которые будет использоваться для логирования, мониторингов и тп

### Запуск всей цепочки для дебага
см. [DebugEssRunner](../full-ess-chain/README.md)

### Мониторинг и другое
Основная используемая метрика - время отставания от создания бинлога. Она измеряется после обработки пачки бинлогов router'ом, а также после применения бинес-логики.
Измеряется в секундах. Метрика отправляется в solomon и в juggler, если время отставания превысило критическое.
Кроме этого, для каждого logic-processor'а в solomon отправляется количество прочитанные байт и количество прочитанных объектов.
Дашборды в solomon: [прод](https://solomon.yandex-team.ru/?project=direct&dashboard=ess), [тест](https://solomon.yandex-team.ru/?project=direct-test&dashboard=ess-router-test)

# Выгрузка содержимого топика в ClickHouse
Для просмотра того, что было записано после фильтрации в топик, используется таблица в ClickHouse - ess_logic_objects. Таблица отображается в [logviewer](https://direct.yandex.ru/logviewer#ess_logic_objects,20190516T000000,20190516T235959,false,1:101,2,logic_object_attr,logic_object_value).
Чтобы выгружать данные из своего топика в ClickHouse, нужно дописать в [файл](../../../packages/yandex-du-logshatter-cloud-crossdc-conf/etc/yandex/logshatter/conf.d/ess_logic_objects.json) в поле sources свой топик(в это время он уже должен быть создан), собрать и выложить пакет yandex-du-logshatter-cloud-crossdc-conf.
Для непроакшеновых сред, дописывать в файлы ess_logic_objects* в [директории](../../../packages/yandex-du-logshatter-testing-crossdc-conf/etc/yandex/logshatter/conf.d)

# Ограничения
1. Нельзя указывать одинаковые топики для разных logic-processor'ов
