package ru.yandex.direct.ess.common.circuits.moderation;

import java.util.stream.Stream;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;

public enum ModerationArchivingObjectType {

    CAMPAIGN("campaign"),

    BANNER("banner");

    private static final ImmutableMap<String, ModerationArchivingObjectType> map;

    static {
        ImmutableMap.Builder<String, ModerationArchivingObjectType> builder = ImmutableMap.builder();
        Stream.of(ModerationArchivingObjectType.values())
                .forEach(t -> builder.put(t.value, t));
        map = builder.build();
    }

    private final String value;

    ModerationArchivingObjectType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getStringValue() {
        return value;
    }

    @JsonCreator
    public static ModerationArchivingObjectType getEnumValue(String value) {
        return map.get(value);
    }
}
