package ru.yandex.direct.ess.common.circuits.moderation;

import java.util.stream.Stream;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;

public enum ModerationDeletionObjectType {
    ADGROUP("adgroup"),

    // для всех типов баннеров отправляется один тип,
    // так как в общем случае при удалении невозможно точно определить тип
    BANNER("banner"),

    // все возможные креативы из banners_performance отправляем как creative,
    // так как гарантированно не можем определить тип
    ASSET_CREATIVE("creative"),

    // эти ассеты умеем определять
    ASSET_IMAGE("image_sm"),
    ASSET_TURBOLANDING("turbolink"),
    ASSET_DISPLAY_HREF("display_href_sm"),
    ASSET_VCARD("asset_vcard"),
    ASSET_SITELINK_SET("sitelinks_set_sm"),
    ASSET_LOGO("asset_icon"),
    ASSET_BUTTON("asset_button_url");

    private static final ImmutableMap<String, ModerationDeletionObjectType> map;

    static {
        ImmutableMap.Builder<String, ModerationDeletionObjectType> builder = ImmutableMap.builder();
        Stream.of(ModerationDeletionObjectType.values())
                .forEach(t -> builder.put(t.value, t));
        map = builder.build();
    }

    private final String value;

    ModerationDeletionObjectType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getStringValue() {
        return value;
    }

    @JsonCreator
    public static ModerationDeletionObjectType getEnumValue(String value) {
        return map.get(value);
    }
}
