package ru.yandex.direct.ess.common.converter;

import com.fasterxml.jackson.databind.JavaType;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.LogicObjectListWithInfo;
import ru.yandex.direct.utils.JsonUtils;

public class LogicObjectWithSystemInfoConverter<T extends BaseLogicObject> {
    private JavaType typeToConvert;

    public LogicObjectWithSystemInfoConverter(Class<? extends BaseLogicObject> logicObjectClazz) {
        this.typeToConvert =
                JsonUtils.getTypeFactory().constructParametricType(LogicObjectListWithInfo.class, logicObjectClazz);
    }

    public LogicObjectListWithInfo<T> fromJson(byte[] bytes) {
        return JsonUtils.fromJson(bytes, typeToConvert);
    }

    public byte[] toJson(LogicObjectListWithInfo<T> logicObjectListWithInfo) {
        return JsonUtils.toJsonBytesForType(typeToConvert, logicObjectListWithInfo);
    }

    public static LogicObjectWithSystemInfoConverter<BaseLogicObject> getDefaultConverter() {
        return new LogicObjectWithSystemInfoConverter<>(BaseLogicObject.class);
    }
}
