package ru.yandex.direct.ess.common.logbroker;

import java.util.List;

import com.google.common.base.Preconditions;

import static org.apache.commons.collections.CollectionUtils.isEmpty;

/**
 * Универсальная имплементация LogbrokerConsumerProperties.
 * По задумке должна подойти в любом стандартном случае.
 * Default методы интерфейса можно не конфигурирвать - тогда будет вызвана default имплементация.
 */
public class LogbrokerConsumerPropertiesImpl implements LogbrokerConsumerProperties {

    private final String host;
    private final String readTopic;
    private final String consumerName;
    private final long readDataTimeoutSec;
    private final long initTimeoutSec;
    private final int retries;
    private final List<Integer> groups;
    private final Integer readBufferSize;

    private LogbrokerConsumerPropertiesImpl(String host, String readTopic, String consumerName, long readDataTimeoutSec,
                                            long initTimeoutSec, int retries, List<Integer> groups,
                                            Integer readBufferSize) {
        this.host = host;
        this.readTopic = readTopic;
        this.consumerName = consumerName;
        this.readDataTimeoutSec = readDataTimeoutSec;
        this.initTimeoutSec = initTimeoutSec;
        this.retries = retries;
        this.groups = groups;
        this.readBufferSize = readBufferSize;
    }

    @Override
    public String getHost() {
        return host;
    }

    @Override
    public String getReadTopic() {
        return readTopic;
    }

    @Override
    public String getConsumerName() {
        return consumerName;
    }

    @Override
    public long getReadDataTimeoutSec() {
        return readDataTimeoutSec;
    }

    @Override
    public long getInitTimeoutSec() {
        return initTimeoutSec;
    }

    @Override
    public int getRetries() {
        return retries;
    }

    @Override
    public List<Integer> getGroups() {
        return groups;
    }

    @Override
    public int getReadBufferSize() {
        return readBufferSize == null ? LogbrokerConsumerProperties.super.getReadBufferSize() : readBufferSize;
    }

    public static class Builder {
        private String host;
        private String readTopic;
        private String consumerName;
        private long readDataTimeoutSec;
        private long initTimeoutSec;
        private int retries;
        private List<Integer> groups;
        private Integer readBufferSize;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setReadTopic(String readTopic) {
            this.readTopic = readTopic;
            return this;
        }

        public Builder setConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public Builder setReadDataTimeoutSec(long readDataTimeoutSec) {
            this.readDataTimeoutSec = readDataTimeoutSec;
            return this;
        }

        public Builder setInitTimeoutSec(long initTimeoutSec) {
            this.initTimeoutSec = initTimeoutSec;
            return this;
        }

        public Builder setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder setGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setReadBufferSize(Integer readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public LogbrokerConsumerPropertiesImpl build() {
            Preconditions.checkState(host != null, "forgotten host");
            Preconditions.checkState(readTopic != null, "forgotten readTopic");
            Preconditions.checkState(consumerName != null, "forgotten consumerName");
            Preconditions.checkState(readDataTimeoutSec != 0, "forgotten readDataTimeoutSec");
            Preconditions.checkState(initTimeoutSec != 0, "forgotten initTimeoutSec");
            Preconditions.checkState(retries != 0, "forgotten retries");
            Preconditions.checkState(!isEmpty(groups), "forgotten groups");
            return new LogbrokerConsumerPropertiesImpl(host, readTopic, consumerName, readDataTimeoutSec,
                    initTimeoutSec, retries, groups, readBufferSize);
        }
    }
}
