package ru.yandex.direct.ess.common.models;

import java.time.Duration;

public abstract class BaseEssConfig {
    public abstract String getTopic();

    private static final int DEFAULT_ROWS_THRESHOLD = 10_000;
    private static final Duration DEFAULT_TIME_TO_READ_THRESHOLD = Duration.ofSeconds(5);

    /**
     * @return - object that extends BaseLogicObject, which contains the fields required for custom logic process.
     */
    public abstract Class<? extends BaseLogicObject> getLogicObject();

    /**
     * @return - maximum count of logbroker messages to read in one iteration
     */
    public abstract int getRowsThreshold();

    /**
     * @return - maximum time for one reading iteration
     */
    public abstract Duration getTimeToReadThreshold();

    /**
     * @return - critical time from binlog creation to the completion of the business logic process.
     * If process runs longer than this time, the monitoring will be alert by Juggler.
     */

    public abstract Duration getCriticalEssProcessTime();

    /**
     * @return - name that defines custom logic process ans will be used in monitoring and logs
     */
    public abstract String getLogicProcessName();

    /**
     * @return - would resharding events be processed
     */
    public boolean processReshardingEvents() {
        return false;
    }

    protected static int getDefaultRowsThreshold() {
        return DEFAULT_ROWS_THRESHOLD;
    }

    protected static Duration getDefaultTimeToReadThreshold() {
        return DEFAULT_TIME_TO_READ_THRESHOLD;
    }
}
