package ru.yandex.direct.ess.common.models;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Collections.emptyList;

@SuppressWarnings({"FieldCanBeLocal", "unused"})
public class LogicObjectListWithInfo<T extends BaseLogicObject> {

    @JsonProperty("reqId")
    private long reqId;

    @JsonProperty("utcTimestamp")
    private Long utcTimestamp;

    @JsonProperty("gtid")
    private String gtid;

    @JsonProperty("seqNo")
    private Long seqNo;

    @JsonProperty("source")
    private String source;

    @JsonProperty("logicObjectsList")
    private List<T> logicObjectsList;

    @JsonProperty("isPingObject")
    private boolean isPingObject;


    @JsonCreator
    public LogicObjectListWithInfo(
            @JsonProperty("reqId") long reqId,
            @JsonProperty("utcTimestamp") Long utcTimestamp,
            @JsonProperty("gtid") String gtid,
            @JsonProperty("seqNo") Long seqNo,
            @JsonProperty("source") String source,
            @JsonProperty("logicObjectsList") List<T> logicObjectsList,
            @JsonProperty("isPingObject") boolean isPingObject
    ) {
        this.reqId = reqId;
        this.utcTimestamp = utcTimestamp;
        this.gtid = gtid;
        this.seqNo = seqNo;
        this.source = source;
        this.logicObjectsList = logicObjectsList;
        this.isPingObject = isPingObject;

    }

    public Long getUtcTimestamp() {
        return utcTimestamp;
    }

    public List<T> getLogicObjectsList() {
        return logicObjectsList;
    }

    public boolean getIsPingObject() {
        return isPingObject;
    }

    public static class Builder<T extends BaseLogicObject> {
        private long reqId = 0L;
        private long utcTimestamp = 0L;
        private String gtid = "";
        private long seqNo = 0L;
        private String source = "";
        private List<T> logicObjectsList = emptyList();
        private boolean isPingObject = false;

        public Builder<T> withReqId(long reqId) {
            this.reqId = reqId;
            return this;
        }

        public Builder<T> withUtcTimestamp(long utcTimestamp) {
            this.utcTimestamp = utcTimestamp;
            return this;
        }

        public Builder<T> withGtid(String gtid) {
            this.gtid = gtid;
            return this;
        }

        public Builder<T> withSeqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        public Builder<T> withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder<T> withLogicObjects(List<T> logicObjects) {
            this.logicObjectsList = logicObjects;
            return this;
        }

        public Builder<T> pingObject() {
            this.isPingObject = true;
            return this;
        }

        public LogicObjectListWithInfo<T> build() {
            return new LogicObjectListWithInfo<>(reqId, utcTimestamp, gtid, seqNo, source, logicObjectsList,
                    isPingObject);
        }
    }
}
