package ru.yandex.direct.ess.common.utils;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EssCommonUtils {
    private final String logbrokerPrefix;

    public EssCommonUtils(
            @Value("${ess.logbroker.logbroker_prefix}") String logbrokerPrefix
    ) {
        this.logbrokerPrefix = logbrokerPrefix;
    }

    public String getAbsoluteTopicPath(String topic) {
        return logbrokerPrefix + topic;
    }

    public static String getAbsoluteConsumerPath(String logbrokerPrefix, String consumerName) {
        return logbrokerPrefix + "ess@" + consumerName;
    }
}
