package ru.yandex.direct.ess.common.utils;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;

import ru.yandex.grut.objects.proto.client.Schema.EObjectType;

import static java.util.function.Function.identity;
import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

public enum TablesEnum {
    BANNERS(PPC.BANNERS.getName()),
    PHRASES(PPC.PHRASES.getName()),
    BANNER_IMAGES(PPC.BANNER_IMAGES.getName()),
    CAMPAIGNS(PPC.CAMPAIGNS.getName()),
    CAMPAIGNS_MOBILE_CONTENT(PPC.CAMPAIGNS_MOBILE_CONTENT.getName()),
    HIERARCHICAL_MULTIPLIERS(PPC.HIERARCHICAL_MULTIPLIERS.getName()),
    MOBILE_CONTENT(PPC.MOBILE_CONTENT.getName()),
    ORGANIZATIONS(PPC.ORGANIZATIONS.getName()),
    MINUS_WORDS(PPC.MINUS_WORDS.getName()),
    ADGROUPS_TEXT(PPC.ADGROUPS_TEXT.getName()),
    ADGROUPS_PERFORMANCE(PPC.ADGROUPS_PERFORMANCE.getName()),
    ADGROUPS_DYNAMIC(PPC.ADGROUPS_DYNAMIC.getName()),
    FEEDS(PPC.FEEDS.getName()),
    BANNER_MULTICARDS(PPC.BANNER_MULTICARDS.getName()),
    PROMOACTIONS(PPC.PROMOACTIONS.getName()),
    CAMPAIGN_PROMOACTIONS(PPC.CAMPAIGN_PROMOACTIONS.getName()),
    CAMP_METRIKA_COUNTERS(PPC.CAMP_METRIKA_COUNTERS.getName()),

    // GrUT tables
    BANNER_CANDIDATES(EObjectType.OT_BANNER_CANDIDATE.name().toLowerCase()),
    ;

    private String tableName;

    TablesEnum(String tableName) {
        this.tableName = tableName;
    }

    private static final Map<String, TablesEnum> VALUES_MAP = ImmutableMap.copyOf(
            Arrays.stream(TablesEnum.values())
                    .collect(Collectors.toMap(
                            table -> table.tableName,
                            identity()
                    )));

    @JsonCreator
    public static TablesEnum fromString(String val) {
        return VALUES_MAP.get(val);
    }

    @JsonValue
    public String getTableName() {
        return tableName;
    }

    @Override
    public String toString() {
        return tableName;
    }

}
