package ru.yandex.direct.ess.config.aggregatedstatuses;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.aggregatedstatuses.AggregatedStatusEventObject;

public class AggregatedStatusesConfig extends BaseEssConfig {

    @Override
    public String getTopic() {
        return "ess--aggregated-statuses_update-events";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return AggregatedStatusEventObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 50_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofSeconds(60 + 30);
    }

    @Override
    public String getLogicProcessName() {
        return "aggregated_statuses_updater";
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
