package ru.yandex.direct.ess.config.brandliftrecalc;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.brandliftrecalc.BrandLiftRecalcObject;

public class BrandLiftRecalcConfig extends BaseEssConfig {
    private static final String LOGIC_PROCESS_NAME = "brand_lift_recalc";

    @Override
    public String getTopic() {
        return "ess--brand-lift-recalc";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BrandLiftRecalcObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return getDefaultRowsThreshold();
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
