package ru.yandex.direct.ess.config.bsexport

import java.time.Duration
import javax.annotation.ParametersAreNonnullByDefault
import ru.yandex.direct.ess.common.models.BaseEssConfig
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject

@ParametersAreNonnullByDefault
class BsExportStrategyConfig : BaseEssConfig() {

    companion object {
        private const val LOGIC_PROCESS_NAME = "export_bs_strategies"
    }

    override fun getTopic(): String {
        return "ess--export-bs-strategies"
    }

    override fun getLogicObject(): Class<out BaseLogicObject> {
        return BsExportStrategyObject::class.java
    }

    override fun getRowsThreshold(): Int {
        return 5000
    }

    override fun getTimeToReadThreshold(): Duration {
        return Duration.ofSeconds(2)
    }

    override fun getCriticalEssProcessTime(): Duration {
        return Duration.ofMinutes(10)
    }

    override fun getLogicProcessName(): String {
        return LOGIC_PROCESS_NAME
    }

    override fun processReshardingEvents() = false
}
