package ru.yandex.direct.ess.config.bsexport.adgroup;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject;

public class BsExportAdGroupConfig extends BaseEssConfig {
    private static final String LOGIC_PROCESS_NAME = "export_bs_ad_groups";

    @Override
    public String getTopic() {
        return "ess--export-bs-ad-groups";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BsExportAdGroupObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(2);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    public boolean processReshardingEvents() {
        return false;
    }
}
