package ru.yandex.direct.ess.config.bsexport.adgroup;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject;

public class BsExportAdGroupShowConditionConfig extends BaseEssConfig {
    private static final String LOGIC_PROCESS_NAME = "export_bs_ad_group_show_conditions";

    @Override
    public String getTopic() {
        return "ess--export-bs-ad-group-show-conditions";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BsExportAdGroupShowConditionObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(2);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    public boolean processReshardingEvents() {
        return false;
    }
}
