package ru.yandex.direct.ess.config.bsexport.campaign;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;

public class BsExportCampaignConfig extends BaseEssConfig {
    private static final String LOGIC_PROCESS_NAME = "export_bs_campaigns";

    @Override
    public String getTopic() {
        return "ess--export-bs-campaigns";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BsExportCampaignObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(2);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
