package ru.yandex.direct.ess.config.bsexport.metrikacounters

import ru.yandex.direct.ess.common.models.BaseEssConfig
import ru.yandex.direct.ess.logicobjects.bsexport.metrikacounters.BsExportMetrikaCountersObject
import java.time.Duration

class BsExportMetrikaCountersConfig : BaseEssConfig() {
    companion object {
        const val LOGIC_PROCESS_NAME = "export_bs_metrika_counters"
    }

    override fun getTopic() = "ess--export-bs-metrika-counters"
    override fun getLogicObject() = BsExportMetrikaCountersObject::class.java
    override fun getRowsThreshold() = 5000
    override fun getTimeToReadThreshold(): Duration = Duration.ofSeconds(2)
    override fun getCriticalEssProcessTime(): Duration = Duration.ofMinutes(10)
    override fun getLogicProcessName() = LOGIC_PROCESS_NAME
    override fun processReshardingEvents() = false
}
