package ru.yandex.direct.ess.config.bsexport.multipliers;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.bsexport.multipliers.BsExportMultipliersObject;

public class BsExportMultipliersConfig extends BaseEssConfig {
    private static final String LOGIC_PROCESS_NAME = "export_bs_multipliers";

    @Override
    public String getTopic() {
        return "ess--export-bs-multipliers";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BsExportMultipliersObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(2);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    public boolean processReshardingEvents() {
        return false;
    }
}
