package ru.yandex.direct.ess.config.bsexport.resources;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject;

public class BsExportBannerResourcesConfig extends BaseEssConfig {
    public static final String LOGIC_PROCESS_NAME = "export_bs_banner_resources";

    @Override
    public String getTopic() {
        return "ess--export-bs-banner-resources";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BsExportBannerResourcesObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(2);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
