package ru.yandex.direct.ess.config.campaignlastchange;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.campaignlastchange.CampAggregatedLastchangeObject;

public class CampAggregatedLastchangeConfig extends BaseEssConfig {

    private static final String LOGIC_PROCESS_NAME = "camp_aggregated_last_change";

    @Override
    public String getTopic() {
        return "ess--camp-aggregate-last-change";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return CampAggregatedLastchangeObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 50_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(5);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
