package ru.yandex.direct.ess.config.campaignstatuscorrect;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.campaignstatuscorrect.CampaignStatusCorrectCheckObject;

public class CampaignStatusCorrectCheckConfig extends BaseEssConfig {

    private static final String LOGIC_PROCESS_NAME = "camp_status_correct_check";

    @Override
    public String getTopic() {
        return "ess--camp-status-correct-check";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return CampaignStatusCorrectCheckObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return getDefaultRowsThreshold();
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(5);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
