package ru.yandex.direct.ess.config.campeventlog;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.campeventlog.CampaignEventLogLogicObject;

public class CampaignEventLogConfig extends BaseEssConfig {

    @Override
    public String getTopic() {
        return "ess--camp-eventlog";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return CampaignEventLogLogicObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 50_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(5);
    }

    @Override
    public String getLogicProcessName() {
        return "camp_eventlog";
    }

    @Override
    public boolean processReshardingEvents() {
        // выставлено явно при замене умолчания в базовом классе: DIRECT-171006
        // необязательно означает, что для этого процесса нужно обрабатывать события от решардинга, просто настройку добавили позже: DIRECT-122901
        return true;
    }
}
