package ru.yandex.direct.ess.config.campstatusmoderate;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.moderation.campstatusmoderate.CampaignStatusEventsObject;

public class CampaignStatusModerateConfig extends BaseEssConfig {
    @Override
    public String getTopic() {
        return "ess--campaign-status-moderate";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return CampaignStatusEventsObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 10_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofMinutes(5);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(5);
    }

    @Override
    public String getLogicProcessName() {
        return "set_campaign_statusmoderate";
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
