package ru.yandex.direct.ess.config.conversioncenter

import ru.yandex.direct.ess.common.models.BaseEssConfig
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.logicobjects.conversioncenter.ConversionCenterEventObject
import java.time.Duration

class ConversionCenterEventConfig: BaseEssConfig() {

    companion object {
        private const val LOGIC_PROCESS_NAME = "conversion_center_event"
    }

    override fun getTopic(): String {
        return "ess--conversion-center-event"
    }

    override fun getLogicObject(): Class<out BaseLogicObject> {
        return ConversionCenterEventObject::class.java
    }

    override fun getRowsThreshold(): Int {
        return getDefaultRowsThreshold()
    }

    override fun getTimeToReadThreshold(): Duration {
        return getDefaultTimeToReadThreshold()
    }

    override fun getCriticalEssProcessTime(): Duration {
        return Duration.ofMinutes(10)
    }

    override fun getLogicProcessName(): String {
        return LOGIC_PROCESS_NAME
    }

    override fun processReshardingEvents() = false
}
