package ru.yandex.direct.ess.config.feeds.statusupdate;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.feeds.statusupdate.FeedStatusUpdateObject;

public class FeedStatusUpdateConfig extends BaseEssConfig {

    @Override
    public String getTopic() {
        return "ess--feed-status-update";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return FeedStatusUpdateObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return getDefaultRowsThreshold();
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return "feed_status_update";
    }

    @Override
    public boolean processReshardingEvents() {
        // выставлено явно при замене умолчания в базовом классе: DIRECT-171006
        // необязательно означает, что для этого процесса нужно обрабатывать события от решардинга, просто настройку добавили позже: DIRECT-122901
        return true;
    }
}
