package ru.yandex.direct.ess.config.feeds.usagetypes

import ru.yandex.direct.ess.common.models.BaseEssConfig
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.logicobjects.feeds.usagetypes.FeedUsageTypesObject
import java.time.Duration

class RecalculateFeedUsageTypesConfig : BaseEssConfig() {
    override fun getTopic(): String {
        return "ess--recalculate-feed-usage-types"
    }

    override fun getLogicObject(): Class<out BaseLogicObject?>? {
        return FeedUsageTypesObject::class.java
    }

    override fun getRowsThreshold(): Int {
        return getDefaultRowsThreshold()
    }

    override fun getTimeToReadThreshold(): Duration? {
        return getDefaultTimeToReadThreshold()
    }

    override fun getCriticalEssProcessTime(): Duration? {
        return Duration.ofMinutes(10)
    }

    override fun getLogicProcessName(): String {
        return LOGIC_PROCESS_NAME
    }

    companion object {
        private const val LOGIC_PROCESS_NAME = "recalculate_feed_usage_types"
    }

    override fun processReshardingEvents() = false

}
