package ru.yandex.direct.ess.config.mediascopeintegration;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.mediascopeintegration.MediascopePositionChangeObject;

public class MediascopePositionChangeConfig extends BaseEssConfig {

    @Override
    public String getTopic() {
        return "ess--mediascope-position-change";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return MediascopePositionChangeObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 100;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(5);
    }

    @Override
    public String getLogicProcessName() {
        return "mediascope_position_change";
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
