package ru.yandex.direct.ess.config.metrika.bannerupdate;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.metrika.bannerupdate.MetrikaBannerUpdateObject;

public class MetrikaBannerUpdateConfig extends BaseEssConfig {
    private static final String LOGIC_PROCESS_NAME = "metrika_banner_update";

    @Override
    public String getTopic() {
        return "ess--metrika-banner-update";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return MetrikaBannerUpdateObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(2);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(10);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        // выставлено явно при замене умолчания в базовом классе: DIRECT-171006
        // необязательно означает, что для этого процесса нужно обрабатывать события от решардинга, просто настройку добавили позже: DIRECT-122901
        return true;
    }
}
