package ru.yandex.direct.ess.config.moderation;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;

@EssGroups(EssGroup.MODERATION)
public abstract class BaseModerationConfig extends BaseEssConfig {

    private static final String MODERATION_PROCESSOR_TEMPLATE = "%s_%s";
    private static final String MODERATION_PROCESSOR_PREFIX = "export_moderation";

    @Override
    public int getRowsThreshold() {
        return getDefaultRowsThreshold();
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return getDefaultTimeToReadThreshold();
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(5);
    }

    @Override
    public String getLogicProcessName() {
        return String.format(MODERATION_PROCESSOR_TEMPLATE, MODERATION_PROCESSOR_PREFIX, getModerationProcessName());
    }

    public abstract String getModerationProcessName();

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
