package ru.yandex.direct.ess.config.moderation.adgroup;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.adgroup.AdGroupModerationEventObject;

@EssGroups({EssGroup.MODERATION})
public class AdGroupModerationConfig extends BaseModerationConfig {

    private static final String TOPIC_NAME = "ess--adgroup-moderation";
    private static final String MODERATION_PROCESS_NAME = "adgroup";

    @Override
    public String getTopic() {
        return TOPIC_NAME;
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return AdGroupModerationEventObject.class;
    }

    @Override
    public String getModerationProcessName() {
        return MODERATION_PROCESS_NAME;
    }

}
